/*
 * Decompiled with CFR 0.152.
 */
package Krasnodar.rockstarnew.systems.modules.modules.visuals;

import Krasnodar.rockstarnew.Rockstar;
import Krasnodar.rockstarnew.framework.msdf.Fonts;
import Krasnodar.rockstarnew.framework.objects.BorderRadius;
import Krasnodar.rockstarnew.systems.event.EventListener;
import Krasnodar.rockstarnew.systems.event.impl.render.PreHudRenderEvent;
import Krasnodar.rockstarnew.systems.event.impl.window.KeyPressEvent;
import Krasnodar.rockstarnew.systems.localization.Localizator;
import Krasnodar.rockstarnew.systems.modules.api.ModuleCategory;
import Krasnodar.rockstarnew.systems.modules.api.ModuleInfo;
import Krasnodar.rockstarnew.systems.modules.impl.BaseModule;
import Krasnodar.rockstarnew.utility.colors.ColorRGBA;
import Krasnodar.rockstarnew.utility.game.MessageUtility;
import Krasnodar.rockstarnew.utility.render.Utils;
import Krasnodar.rockstarnew.utility.sounds.ClientSounds;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import lombok.Generated;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_241;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_3532;
import net.minecraft.class_3965;
import net.minecraft.class_4587;

@ModuleInfo(name="Waypoints", category=ModuleCategory.VISUALS, enabledByDefault=true)
public class Waypoints
extends BaseModule {
    private final Map<String, Waypoint> waypoints = new HashMap<String, Waypoint>();
    private final EventListener<KeyPressEvent> onClientPlayerTickEvent = event -> {
        if (event.getKey() == 86 && event.getAction() == 1 && Waypoints.mc.field_1755 == null && Waypoints.mc.field_1724 != null && Waypoints.mc.field_1687 != null) {
            class_243 pos;
            class_243 start = Waypoints.mc.field_1724.method_33571();
            class_243 direction = Waypoints.mc.field_1724.method_5828(mc.method_61966().method_60637(true));
            class_243 end = start.method_1019(direction.method_1021(200.0));
            class_1657 targetPlayer = null;
            double closestDistance = Double.MAX_VALUE;
            for (class_1657 player : Waypoints.mc.field_1687.method_18456()) {
                double distance;
                class_238 hitbox;
                class_243 hit;
                if (player == Waypoints.mc.field_1724 || (hit = (class_243)(hitbox = player.method_5829().method_1014(0.3)).method_992(start, end).orElse(null)) == null || !((distance = start.method_1022(hit)) < closestDistance) || !(distance <= 200.0)) continue;
                closestDistance = distance;
                targetPlayer = player;
            }
            if (targetPlayer != null) {
                UUID playerUUID = targetPlayer.method_5667();
                if (this.waypoints.values().stream().anyMatch(w -> playerUUID.equals(w.playerUUID))) {
                    return;
                }
                String name = targetPlayer.method_5477().getString();
                pos = targetPlayer.method_19538();
                this.add(name, pos.field_1352, pos.field_1351, pos.field_1350, true, playerUUID);
                return;
            }
            class_239 raycastResult = Waypoints.mc.field_1724.method_5745(200.0, mc.method_61966().method_60637(true), false);
            if (raycastResult.method_17783() == class_239.class_240.field_1332 && raycastResult instanceof class_3965) {
                class_3965 blockHit = (class_3965)raycastResult;
                pos = blockHit.method_17784();
                String baseName = Localizator.translate("modules.waypoints.base_name");
                Object name = baseName;
                int counter = 1;
                while (this.waypoints.containsKey(name)) {
                    name = baseName + " " + counter++;
                }
                this.add((String)name, pos.field_1352, pos.field_1351, pos.field_1350, true, null);
            }
        }
    };
    private final EventListener<PreHudRenderEvent> onHudRenderEvent = event -> {
        class_4587 matrices = event.getContext().method_51448();
        float tickDelta = event.getTickDelta();
        long currentTime = System.currentTimeMillis();
        this.waypoints.entrySet().removeIf(entry -> {
            Waypoint waypointx = (Waypoint)entry.getValue();
            if (waypointx.temp && currentTime - waypointx.creationTime > 5000L) {
                return true;
            }
            if (waypointx.playerUUID != null) {
                class_1657 player = Waypoints.mc.field_1687.method_18470(waypointx.playerUUID);
                if (player == null) {
                    MessageUtility.info(class_2561.method_30163((String)Localizator.translate("modules.waypoints.player_removed", waypointx.name)));
                    return true;
                }
                class_243 targetPos = Utils.getInterpolatedPos((class_1297)player, tickDelta);
                float alpha = 0.2f * tickDelta;
                waypointx.pos = waypointx.pos.method_35590(targetPos, (double)class_3532.method_15363((float)alpha, (float)0.0f, (float)1.0f));
            }
            return false;
        });
        for (Waypoint waypoint : this.waypoints.values()) {
            class_243 renderPos = waypoint.pos;
            class_243 renderPosAdjusted = renderPos.method_1031(0.0, 0.5, 0.0);
            class_241 screenPos = Utils.worldToScreen(renderPosAdjusted);
            if (screenPos == null) continue;
            float distance = (float)Waypoints.mc.field_1724.method_19538().method_1022(renderPos);
            float scale = class_3532.method_15363((float)(1.0f - distance / 20.0f), (float)0.5f, (float)1.0f);
            matrices.method_22903();
            matrices.method_46416(screenPos.field_1343, screenPos.field_1342, 0.0f);
            matrices.method_22905(scale, scale, 1.0f);
            String text = waypoint.name + " (" + String.format("%.1f", Float.valueOf(distance)) + "m)";
            int width = (int)Fonts.MEDIUM.getFont(11.0f).width(text);
            int x = -width / 2;
            int iconSize = 32;
            event.getContext().drawRoundedRect((float)(x - 3), 2.0f, (float)(width + 8), Fonts.MEDIUM.getFont(11.0f).height() + 6.0f, BorderRadius.all(3.0f), new ColorRGBA(0.0f, 0.0f, 0.0f, 100.0f));
            event.getContext().drawText(Fonts.MEDIUM.getFont(11.0f), text, x, 5.0f, ColorRGBA.WHITE);
            if (waypoint.playerUUID != null) {
                int iconY = (int)(-22.0f + (Fonts.MEDIUM.getFont(11.0f).height() - (float)iconSize) / 2.0f);
                event.getContext().drawTexture(Rockstar.id("icons/target2.png"), -15.0f, iconY, iconSize, iconSize, ColorRGBA.WHITE);
            }
            matrices.method_22909();
        }
    };

    private void add(String name, double x, double y, double z, boolean isTemp, UUID playerUUID) {
        class_243 pos = new class_243(x, y, z);
        if (this.waypoints.containsKey(name)) {
            MessageUtility.error(class_2561.method_30163((String)Localizator.translate("modules.waypoints.exists", name)));
        } else {
            this.waypoints.put(name, new Waypoint(name, pos, isTemp, System.currentTimeMillis(), playerUUID));
            ClientSounds.MODULE.play(0.5f);
        }
    }

    private static class Waypoint {
        public String name;
        public class_243 pos;
        public boolean temp;
        public long creationTime;
        public UUID playerUUID;

        @Generated
        public Waypoint(String name, class_243 pos, boolean temp, long creationTime, UUID playerUUID) {
            this.name = name;
            this.pos = pos;
            this.temp = temp;
            this.creationTime = creationTime;
            this.playerUUID = playerUUID;
        }
    }
}

